// JavaScript Documen
(function ($) {
    $.su = $.su || {};
    $.su.CHAR = {
        // TTT:{
        FIRMWARE_VERSION: "Firmware Version:",
        HARDWARE_VERSION: "Hardware Version:",
        HELP_SUPPORT: "Support",
        FAQ: "FAQ",
        CONFIRM_REBOOT: "Are you sure to reboot the extender?",
        CONFIRM_LOGOUT: "Are you sure to logout?",
        CONFIRM_LED_ON: "Are you sure to turn on the extender's LED?",
        CONFIRM_LED_OFF: "Are you sure to turn off the extender's LED?",
        REBOOTING: "Rebooting... <br/>Please don't operate during the rebooting process.",

        MODE_SWITCH: "Mode Switch",
        ACCESS_POINT: "Access Point",
        ACCESS_POINT_TIPS: "To transform wired network into wireless.",
        ROUTER: "Router",
        ROUTER_TIPS: "To allow multiple devices to connect wiredly or wirelessly.",
        REPEATER: "Repeater",
        REPEATER_TIPS: "To extend the signal coverage of your wireless network.",
        MODE_REBOOT_TIP: "Modification of Mode will result in the rebooting of this device, are you sure to continue?",
        // },
        LOGIN: {
            NOTE_STR1: "NOTE: Username and password should contains 4 to 15 characters and may not include spaces.",
            NOTE_STR2: "NOTE: The router allows only one administrator to login at the same time, please try again later.",
            NOTE_STR3: "NOTE: You have exceeded ten attempts, please try again in two hours.",
            NOTE_STR4: "NOTE: The username or password is incorrect, please input again.",
            NOTE_STR5: "Your browser is not supported. Please upgrade your browser or switch to another browser. If you are using the Internet Explorer, please do not enable the Compatibility View which may cause the page misaligned.",
            NOTE_STR6: "NOTE: Username is required",
            NOTE_STR7: "NOTE: Password is required",
            NOTE_STR8: "Note: You've already logged in on another web browser, please switch to that browser.",
            LOGIN: "Login",
            RIGHTS_RESERVED: "Copyright &copy; 2018 TP-Link Technologies Co., Ltd. All rights reserved."
        },

        INDEX: {
            UPGRADE_ALERT_1: "The current firmware does not support TP-Link cloud service. We strongly recommend that you download the latest firmware at www.tp-link.com and update it.",
            UPGRADE_ALERT_2: "The current firmware does not support TP-Link cloud service. We strongly recommend that you update the firmware by clicking the Update icon in the upper right corner."
        },

        UPGRADE: {
            FIRMWARE_VERSION: "Firmware Version: ",
            UPGRADE_NOW: "Upgrade now",
            REMIND: "Remind me later",
            NOTICE: "Hi, a new firmware is available for the device.",
            NEVER: "Ignore this version"
        },

        NAV: {
            QUICK_SETUP: "Quick Setup",
            BASIC: "Basic",
            ADVANCED: "Advanced"
        },
        CONTROL: {
            MODE: "Mode",
            LOGIN: "Login",
            LOGOUT: "Logout",
            REBOOT: "Reboot",
            LED: "LED",
            UPDATE: "Update"
        },
        LANGUAGE: {
            EN_US: "English",
            ZH_CN: "简体中文"
        },
        REGION: {
            ALBANIA: "Albania",
            ALGERIA: "Algeria",
            AMERICAN_SAMOA: "American Samoa",
            ARGENTINA: "Argentina",
            ARMENIA: "Armenia",
            AUSTRALIA: "Australia",
            AUSTRIA: "Austria",
            AZERBAIJAN: "Azerbaijan",
            BAHAMAS: "Bahamas",
            BAHRAIN: "Bahrain",
            BELARUS: "Belarus",
            BANGLADESH: "Bangladesh",
            BARBADOS: "Barbados",
            BELARUS: "Belarus",
            BELGIUM: "Belgium",
            BELIZE: "Belize",
            BERUMUDA: "Berumuda",
            BOLIVIA: "Bolivia",
            BOSNIA_HERZEGOWINA: "Bosnia and Herzegowina",
            BRAZIL: "Brazil",
            BRUNEI_DARUSSALAM: "Brunei Darussalam",
            BULGARIA: "Bulgaria",
            CAMBODIA: "Cambodia",
            CANADA: "Canada",
            CAYMAN_ISLANDS: "Cayman Islands",
            CHILE: "Chile",
            CHINA: "People's Republic of China",
            COLOMBIA: "Colombia",
            COSTA_RICA: "Costa Rica",
            CROATIA: "Croatia",
            CYPRUS: "Cyprus",
            MONTENEGRO: "Montenegro",
            CZECH_REPUBLIC: "Czech Republic",
            DENMARK: "Denmark",
            DOMINICAN_REPUBLIC: "Dominican Republic",
            ECUADOR: "Ecuador",
            EGYPT: "Egypt",
            EL_SALVADOR: "El Salvador",
            ETHIOPIA: "Ethiopia",
            ESTONIA: "Estonia",
            FAEROE_ISLANDS: "Faeroe Islands",
            FINLAND: "Finland",
            FRANCE: "France",
            FRENCH_GUIANA: "French Guiana",
            FRENCH_POLYNESIA: "French Polynesia",
            GEORGIA: "Georgia",
            GERMANY: "Germany",
            GREECE: "Greece",
            GREENLAND: "Greenland",
            GRENADA: "Grenada",
            GUADELOUPE: "Guadeloupe",
            GUAM: "Guam",
            GUATEMALA: "Guatemala",
            HAITI: "Haiti",
            HONDURAS: "Honduras",
            HONG_KONG: "Hong Kong S.A.R., P.R.C.",
            HUNGARY: "Hungary",
            ICELAND: "Iceland",
            INDIA: "India",
            INDONESIA: "Indonesia",
            IRAN: "Iran",
            IRAQ: "Iraq",
            IRELAND: "Ireland",
            ISRAEL: "Israel",
            ITALY: "Italy",
            JAMAICA: "Jamaica",
            JAPAN: "Japan",
            JAPAN_1: "Japan 1",
            JAPAN_2: "Japan 2",
            JAPAN_3: "Japan 3",
            JAPAN_4: "Japan 4",
            JAPAN_5: "Japan 5",
            JAPAN_6: "Japan 6",
            JORDAN: "Jordan",
            KAZAKHSTAN: "Kazakhstan",
            KENYA: "Kenya",
            NORTH_KOREA: "North Korea",
            KOREA_REPUBLIC: "Korea Republic",
            KOREA_REPUBLIC_3: "Korea Republic 3",
            KUWAIT: "Kuwait",
            LATVIA: "Latvia",
            LEBANON: "Lebanon",
            LIBYA: "Libya",
            LIECHTENSTEIN: "Liechtenstein",
            LITHUANIA: "Lithuania",
            LUXEMBOURG: "Luxembourg",
            MACAU: "Macau SAR",
            MACEDONIA: "the Former Yugoslav Republic of Macedonia",
            MALAWI: "Malawi",
            MALAYSIA: "Malaysia",
            MALDIVES: "Maldives",
            MALTA: "Malta",
            MARTHINIQUE: "Martinique",
            MAURITIUS: "Mauritius",
            MAYOTTE: "Mayotte",
            MEXICO: "Mexico",
            MONACO: "Principality of Monaco",
            MONGOLIA: "Mongolia",
            MOROCCO: "Morocco",
            NEPAL: "Nepal",
            NETHERLANDS: "Netherlands",
            NETHERLANDS_ANTILLES: "Netherlands-Antilles",
            ARUBA: "Aruba",
            NEW_ZEALAND: "New Zealand",
            NICARAGUA: "Nicaragua",
            NIGERIA: "Nigeria",
            NORWAY: "Norway",
            NORTHERN_MARIANA_ISLANDS: "Northern Mariana Islands",
            OMAN: "Oman",
            PAKISTAN: "Islamic Republic of Pakistan",
            PANAMA: "Panama",
            PAPUA_NEW_GUINEA: "Papua New Guinea",
            PARAGUAY: "Paraguay",
            PERU: "Peru",
            PHILIPPINES: "Republic of the Philippines",
            POLAND: "Poland",
            PORTUGAL: "Portugal",
            PUERTO_RICO: "Puerto Rico",
            QATAR: "Qatar",
            REUNION: "Reunion",
            ROMANIA: "Romania",
            RUSSIA: "Russia",
            RWANDA: "Rwanda",
            SAMOA: "Samoa",
            SAUDI_ARABIA: "Saudi Arabia",
            SINGAPORE: "Singapore",
            SLOVAK_REPUBLIC: "Slovak Republic",
            SLOVENIA: "Slovenia",
            SOUTH_AFRICA: "South Africa",
            SPAIN: "Spain",
            SRI_LANKA: "Sri Lanka",
            SURINAME: "Suriname",
            SWEDEN: "Sweden",
            SWITZERLAND: "Switzerland",
            SYRIA: "Syria",
            TAIWAN: "Taiwan",
            TANZANIA: "Tanzania",
            THAILAND: "Thailand",
            TRINIDAD_TOBAGO: "Trinidad y Tobago",
            TUNISIA: "Tunisia",
            TURKEY: "Turkey",
            UAE: "U.A.E.",
            UGANDA: "Uganda",
            UKRAINE: "Ukraine",
            UNIVERSAL:"Universal",
            UNITED_ARAB_EMIRATES: "United Arab Emirates",
            UNITED_KINGDOM: "United Kingdom",
            UNITED_STATES: "United States",
            URUGUAY: "Uruguay",
            UZBEKISTAN: "Uzbekistan",
            VENEZUELA: "Venezuela",
            VIETNAM: "Viet Nam",
            VIRGIN_ISLANDS: "Virgin Islands(U.S.)",
            YEMEN: "Yemen",
            ZIMBABWE: "Zimbabwe"
        },
        TIME_ZONE: {
            ENIWETOK: "(GMT-12:00) Eniwetok, Kwajalein",
            MIDWAY_ISLAND_SAMOA: "(GMT-11:00) Midway Island,Samoa",
            HAWAII: "(GMT-10:00) Hawaii",
            ALASKA: "(GMT-09:00) Alaska",
            PACIFIC_TIME: "(GMT-08:00) Pacific Time",
            MOUNTAIN_TIME: "(GMT-07:00) Mountain Time (US Canada)",
            CENTRAL_TIME: "(GMT-06:00) Central Time (US Canada)",
            EASTERN_TIME: "(GMT-05:00) Eastern Time (US Canada)",
            CARACAS: "(GMT-04:30) Caracas",
            ATLANTIC_TIME: "(GMT-04:00) Atlantic Time (Canada)",
            NEWFOUNDLAND: "(GMT-03:30) Newfoundland",
            BRASILIA_BUENOS_AIRES: "(GMT-03:00) Brasilia, Buenos Aires",
            MID_ATLANTIC: "(GMT-02:00) Mid-Atlantic",
            AZORES_CAPE_VERDE_IS: "(GMT-01:00) Azores, Cape Verde Is",
            GREENWICH_MEAN_TIME: "(GMT) Greenwich Mean Time, Dublin, London",
            BERLIN_STOCKHOLM: "(GMT+01:00) Berlin, Stockholm, Rome, Bern, Brussels",
            ATHENS_HELSINKI: "(GMT+02:00) Athens, Helsinki, Eastern Europe, Israel",
            BAGHDAD_KUWAIT: "(GMT+03:00) Baghdad, Kuwait, Nairobi, Riyadh, Moscow",
            TEHERAN: "(GMT+03:30) Teheran",
            ABU_DHABI: "(GMT+04:00) Abu Dhabi, Muscat, Kazan, Volgograd",
            KABUL: "(GMT+04:30) Kabul",
            ISLAMABAD_KARACHI: "(GMT+05:00) Islamabad, Karachi, Ekaterinburg",
            MADRAS_CALCUTTA: "(GMT+05:30) Madras, Calcutta, Bombay, New Delhi",
            KATMANDU: "(GMT+05:45) Katmandu",
            ALMA_ATA_DHAKA: "(GMT+06:00) Alma-Ata, Dhaka",
            RANGOON: "(GMT+06:30) Rangoon",
            BANGKOK_JAKARTA_HANOI: "(GMT+07:00) Bangkok, Jakarta, Hanoi",
            BEIJING_HONGKONG: "(GMT+08:00) Beijing, Hong Kong, Perth, Singapore",
            TOKYO_OSAKA_SAPPORO: "(GMT+09:00) Tokyo, Osaka, Sapporo, Seoul, Yakutsk",
            ADELAIDE: "(GMT+09:30) Adelaide",
            BRISBANE_CANBERRA: "(GMT+10:00) Brisbane, Canberra, Melbourne, Sydney",
            MAGADAN_SOLOMAN_IS: "(GMT+11:00) Magadan, Solomon Is., New Caledonia",
            FIJI_KAMCHATKA: "(GMT+12:00) Fiji, Kamchatka, Auckland",
            NUKU: "(GMT+13:00) Nuku'alofa"
        },
        DATE: {
            DAY: "Day",
            MONDAY: "Monday",
            TUESDAY: "Tuesday",
            WEDNESDAY: "Wednesday",
            THURSDAY: "Thursday",
            FRIDAY: "Friday",
            SATURDAY: "Saturday",
            SUNDAY: "Sunday",
            MON: "Mon.",
            TUES: "Tue.",
            WED: "Wed.",
            THUR: "Thu.",
            FRI: "Fri.",
            SAT: "Sat.",
            SUN: "Sun.",
            JAN: "Jan.",
            FEB: "Feb.",
            MAR: "Mar.",
            APR: "Apr.",
            MAY: "May.",
            JUN: "Jun.",
            JUL: "Jul.",
            AUG: "Aug.",
            SEP: "Sep.",
            OCT: "Oct.",
            NOV: "Nov.",
            DEC: "Dec."
        },
        HOUR: {
            AM_1: "1a.m.",
            AM_2: "2a.m.",
            AM_3: "3a.m.",
            AM_4: "4a.m.",
            AM_5: "5a.m.",
            AM_6: "6a.m.",
            AM_7: "7a.m.",
            AM_8: "8a.m.",
            AM_9: "9a.m.",
            AM_10: "10a.m.",
            AM_11: "11a.m.",
            AM_12: "12a.m.",
            PM_1: "1p.m.",
            PM_2: "2p.m.",
            PM_3: "3p.m.",
            PM_4: "4p.m.",
            PM_5: "5p.m.",
            PM_6: "6p.m.",
            PM_7: "7p.m.",
            PM_8: "8p.m.",
            PM_9: "9p.m.",
            PM_10: "10p.m.",
            PM_11: "11p.m.",
            PM_12: "12p.m."
        },
        ORDER: {
            "1ST": "First",
            "2ND": "2nd",
            "3RD": "3rd",
            "4TH": "4th",
            "5TH": "Last"
        },
        GRID: {
            ID: "ID",
            OPERATION: "Operation",
            AUTO_REFRESH: "Auto Refresh",
            DISABLED: "Disabled",
            ENABLED: "Enabled",
            CLIENT_NUMBER: "Client Number",
            MODIFY: "Modify",
            STATUS: "Status",
            ENABLE: "Enable",
            CHOOSE: "Choose",
            DESCRIPTION: "Description",
            REFRESH: "Refresh",
            NUMBER: "Number",
            ACTIVE: "Active",
            SELECTED: ""
        },
        OPERATION: {
            ADD: "Add",
            CHOOSE: "Choose",
            EDIT: "Edit",
            DELETE: "Delete",
            DELETE_ALL: "Delete All",
            REMOVE: "Remove",
            RESET: "Reset",
            RESET_ALL: "Reset All",
            DETECT: "Detect",
            ENABLE: "Enable",
            DISABLE: "Disable",
            REFRESH: "Refresh",
            SEARCH: "Search...",
            BROWSE: "Browse",
            SAVE: "Save",
            BACK: "Back",
            PREV: "Prev",
            NEXT: "Next",
            FINISH: "Finish",
            ON: "On",
            OFF: "Off",
            LOW: "Low",
            MIDDLE: "Middle",
            HIGH: "High",
            OK: "OK",
            CANCEL: "Cancel",
            YES: "Yes",
            NO: "No",
            CONNECTED: "Connected",
            CONNECTING: "Connecting",
            DISCONNECTING: "Disconnecting",
            DISCONNECTED: "Not Connected",
            PASSWORD_HINT: "Password",
            FILEBUTTONTEXT: "Browse",
            FILEBLANKTEXT: "Please select a file.",
            NOSELECTEDTEXT: "Select options.",
            ADD_A_NEW_KEYWORD: "Add a New Keyword",
            SUCCESSED: "Success!",
            FORM_SAVED: "Saved",
            FORM_FAILED: "Failed",
            GRID_ID_COLUMN: "ID",
            GRID_SAVED: "Saved",
            GRID_FAILED: "Failed",
            GRID_NONE_SELECT: "Please select at least one entry.",
            GRID_DELETE_COMFIRM: "Are you sure to delete these entries?",
            GRID_SINGLEITEM_DELETE_COMFIRM: "Are you sure to delete this entry?",
            GRID_DELETE_ALL_COMFIRM: "Are you sure to delete all the entries?",
            GRID_DELETE_ONE_COMFIRM: "Are you sure to remove the device from the network?",
            GRID_MAX_RULES: "Maximum entries exceeded.",
            KEYWORD_MAX_OVERFLOW: "The number of keywords has exceeded the limit.",
            NOTE: "Note:"
        },
        VTYPETEXT: {
            INVALIDTEXT: "Invalid format.",
            BLANKTEXT: "This field is required.",
            TOOSHORTTEXT: "Enter a password between 4 and 15 characters.",
            PWDTOOSHORT: "Enter a username between 4 and 15 characters.",
            EMAIL: "Invalid email address.",
            NUMBER: "Invalid format.",
            NUMBER_MIN: "Invalid value, please enter a number greater than %min.",
            NUMBER_MAX: "Invalid value, please enter a number less than %max.",
            NUMBER_MIN_MAX: "Invalid value, please enter a number between %min and %max.",
            HEX: "This field should be a hexadecimal number.",
            IP: "Invalid format.",
            IP_NO_ALL_ZERO: "The address should not be 0.0.0.0.",
            IP_NO_LOOP: "The address should not be loopback address.",
            IP_NO_D_TYPE: "The address should not be a class D IP.",
            IP_NO_E_TYPE: "The address should not be a class E IP.",
            IP_NO_ALL_ONE: "The address should not be 255.255.255.255.",
            IP_NO_FIRST_ALL_ONE: "The address should not start with 255.",
            IP_NO_FIRST_ZERO: "The address should not start with 0.",
            MASK_NO_ALL_ONE: "Mask can not be 255.255.255.255.",
            IPV6: "Invalid format.",
            IPV6_NOT_GLOBAL: "Invalid format.",
            IPV6_NOT_PREFIX: "Invalid format.",
            IP_DOMAIN: "Invalid format.",
            IPV6_DOMAIN: "Invalid format.",
            MAC: "Invalid format. e.g. 00-0C-29-88-8A-BD",
            MULTI_MAC: "Invalid format.",
            DATE: "Invalid Dates.",
            DATE_INVALID: "Please enter a date between 01/01/1970 and 12/31/2030.",
            MASK: "Invalid format.",
            DOMAIN: "Invalid format.",
            STRING_DOMAIN: "Invalid format.",
            USER: "Invalid format.",
            NOTE: "Invalid format.",
            PWD: "Invalid format.",
            PLC_PWD: "Incorrect Device Password",
            PLC_NAME: "Incorrect Network Name",
            SSID: "Invalid format.",
            NAME: "Invalid format.",
            ASCII_VISIBLE: "Invalid format.",
            STRING_VISIBLE: "Invalid format.",
            STRING_VISIBLE_NO_COMMA: "Invalid format.",
            STRING_VISIBLE_ALLOW_BLANK: "Invalid format.",
            PLC_INVALID_LENGTH: "Please enter a name of 4 to 23 characters.",
            PLC_INVALID_CHARACTER: "Invalid character."
        },
        ERROR: {
            "00000001": "Invalid file format. ",
            "00000002": "Wrong file.",
            "00000003": "File size limit exceeded.",
            "00000004": "Upload Error.",
            "00000005": "Reboot Error.",
            "00000006": "Unknown Error.",
            "00000007": "The item already exists. Please enter another one.",
            "00000008": "The item overlaps with another entry.",
            "00000013": "Please select some days.",
            "00000009": "Invalid port.",
            "00000010": "The port should be a number.",
            "00000011": "Username should be the same with the From value.",
            "00000012": "The username must start with an alphabet character.",
            "00000021": "Invalid format.",
            "00000032": "Value must be less than Low.",
            "00000033": "Value must be less than Middle and Low.",
            "00000034": "Invalid value, please enter a number between 5 and 7200.",
            "00000039": "Please use the default value 0 or enter a value between 30 and 86400.",
            "00000040": "SSID and MAC address are required.",
            "00000042": "Please use the default value 80 or enter a value between 1024 and 65535.",
            "00000045": "Default Gateway and LAN IP address should be in a same subnet. Please enter again.",
            "00000047": "IP address and LAN IP address should be in the same subnet. Please enter again.",
            "00000049": "Destination Network is invalid.",
            "00000050": "Bad DNS Server IP address. Please input another IP address.",
            "00000051": "This MAC address already exists. Please enter another one.",
            "00000052": "This IP address already exists. Please enter another one.",
            "00000053": "The starting address should not be larger than the ending address. <br/>Please enter again.",
            "00000054": "IP address pool and LAN IP address should be in the same subnet. Please enter again.",
            "00000055": "IP can not be same to the LAN address.",
            "00000056": "The remote IP address and the current LAN IP address should not be in the same subnet. Please enter another one.",
            "00000057": "Invalid PSK Password, please input again.",
            "00000058": "Invalid WEP Password, please input again.",
            "00000059": "Invalid Subnet Mask or LAN IP address, please enter a valid one.",
            "00000060": "WAN IP address and LAN IP address should not be in the same subnet. <br/>Please enter another one.",
            "00000061": "The beginning time should be earlier than the ending time.",
            "00000062": "This field is required.",
            "00000063": "This field is required.",
            "00000064": "Cannot block the host MAC address.",
            "00000065": "This item is conflicted with existed items. Please check.",
            "00000066": "The password should be 8 to 63 characters or 64 hexadecimal digits.",
            "00000067": "The password should be 10 hexadecimal digits.",
            "00000068": "The password should be 5 ASCII characters.",
            "00000069": "The password should be 26 hexadecimal digits.",
            "00000070": "The password should be 13 ASCII characters.",
            "00000071": "The password should be 32 hexadecimal digits.",
            "00000072": "The password should be 16 ASCII characters.",
            "00000073": "The password should be less than 64 characters.",
            "00000074": "Invalid file type.",
            "00000075": "The PIN length should be 8.",
            "00000076": "The entry conflicts with existed items. Please check trigger port and trigger protocol.",
            "00000077": "IP address can not be the same with the LAN IP address.",
            "00000078": "Host IP address can not be the same with the LAN IP address.",
            "00000079": "Invalid Subnet Mask or Gateway IP address, please enter a valid one.",
            "00000082": "Incorrect Username.",
            "00000080": "Passwords mismatch. Please try again.",
            "00000081": "Incorrect Password.",
            "00000088": "This operation is not allowed for remote management.",
            "00000089": "You have exceeded %num attempts. Please try again in two hours.",
            "00000090": "The destination can not be the LAN IP address.",
            "00000091": "The destination can not be the WAN IP address.",
            "00000092": "The IP address and the LAN IP address should not be in the same subnet. <br/>Please enter again.",
            "00000093": "The IP address and the WAN IP address should not be in the same subnet. <br/>Please enter again.",
            "00000094": "The VLAN IDs can not be the same.",
            "00000095": "At least one VLAN ID is required.",
            "00000096": "The keyword already exists.",
            "00000097": "Configurations made to the 2.4GHz frequency bands will not take effect until the Wi-Fi button is ON.",
            "00000098": "Configurations made to the 5GHz frequency bands will not take effect until the Wi-Fi button is ON.",
            "00000099": "Configurations made to the 2.4GHz and 5GHz frequency bands will not take effect until the Wi-Fi button is ON.",
            "00000100": "The 5GHz network configuration is not available due to the restrictions in your region/country.",
            "00000101": "Your wireless function is turned off. If you want to use this function. Please turn on the Wi-Fi button.",
            "00000102": "Your wireless function is turned off. If you want to use this function. Please turn on the Wi-Fi button.",
            "00000103": "Your wireless function is turned off. If you want to use this function. Please turn on the Wi-Fi button.",
            "00000104": "Your wireless function is disabled.",
            "00000105": "QoS and IPTV cannot be enabled at the same time.",
            "00000106": "IP address can not be the same with the LAN IP address.",
            "00000107": "The destination already exists.",
            "00000110": "The IP address and LAN IP address should be in the same subnet.",
            "00000111": "QoS and <a onclick=\"$.su.menu.advanced.goTo('system-parameters');\" src=\"void(0)\">NAT Boost</a> cannot be enabled at the same time.",
            "00000112": "The WDS function can work either at 2.4GHz or 5GHz band. Also, the Guest Network is not available on the WDS band.",
            "00000113": "WDS and Guest Network cannot be enabled at the same time.",
            "00000114": "Traffic Statistics and <a onclick=\"$.su.menu.advanced.goTo('system-parameters');\" src=\"void(0)\">NAT Boost</a> cannot be enabled at the same time.",
            "00000117": "The domain name already exists.",
            "00000118": "The number of domain names has exceeded the limit.",
            "00000119": "NAT Boost will be disabled when either QoS or Traffic Statistics is enabled.",
            "00000120": "The password should be 5 or 13 ASCII characters.",
            "00000121": "The password should be 10 or 26 hexadecimal digits.",
            "00000122": "The username and password are empty, are you sure to continue?",
            "00000123": "Saving... Please don't operate during the process.",
            "00000124": "The router's PIN is locked due to repeatedly connections using wrong PIN. Please generate a new one.",
            "00000125": "Invalid Powerline network name, please input again.",
            "00100001": "Start time should be earlier than End time.",
            "00100002": "End time should be later than Start time.",

            "10000139": "Unable to check for upgrade. Make sure you are connected to the Internet and try again.",
            "10000140": "Unable to upgrade. Make sure you are connected to the Internet and try again.",
            "10000141": "No internet connection",
            "10000172": "Connection failed.",
            "10000191": "Unable to download the firmware file.",
            "10000192": "Unable to upgrade.",
            "10000193": "Unable to connect to the server.",
            "10000194": "Unable to connect to the cloud server. Please try again later.",
            "10000195": "You cannot set the password again because you have set one.",

            "99999999": ""
        },
        MENU: {
            STATUS: "Status",
            NETWORK: "Device Settings",
            INTERNET: "Internet",
            LAN: "LAN Settings",
            LED: "LED Schedules",
            PLC: "Powerline",
            DHCP_SERVER: "DHCP Server",
            DYNAMIC_DNS: "Dynamic DNS",
            ADVANCED_ROUTING: "Advanced Routing",
            WIRELESS: "Wireless",
            WIRELESS_SETTINGS: "Settings",
            WIRELESS_TIME_CONTROL: "Wi-Fi Schedules",
            WIRELESS_CLONE_SELECT: "Wi-Fi Clone",
            WIRELESS_MOVE: "Wi-Fi Move",
            WIRELESS_BAND: "Wireless Band",
            WDSBRIDGING: "WDS Bridging",
            WPS: "WPS",
            MACFILTERING: "MAC Filter",
            WIRE_STATISTICS: "Clients",
            GUEST_NETWORK: "Guest Network",
            WIRELESS_SETTINGS: "Settings",
            STORAGE_SHARING: "Storage Sharing",
            NAT_FORWARDING: "NAT Forwarding",
            NAT: "ALG",
            VIRTUAL_SERVERS: "Virtual Servers",
            PORT_TRIGGERING: "Port Triggering",
            DMZ: "DMZ",
            UPNP: "UPnP",
            ALG: "ALG",
            USB_SETTINGS: "USB Settings",
            BASIC_SET: "Basic Settings",
            DISK_SET: "Device Settings",
            FOLDER_SHARING: "Sharing Access",
            STORAGE_SHARING: "Storage Sharing",
            FTP_SERVER: "FTP Server",
            MEDIA_SERVER: "Media Server",
            PRINT_SERVER: "Print Server",
            G3_G4: "3G/4G",
            PARENTAL_CONTROL: "Parental Controls",
            QOS: "QoS",
            DATABASE: "Database",
            STREAMBOOST: "Stream Boost",
            MAP: "Map",
            SB_MAP: "Map",
            SB_BANDWIDTH: "Bandwidth",
            SB_PRIORITY: "Priority",
            SB_STATISTICS: "Statistics",
            SECURITY: "Security",
            SETTINGS: "Settings",
            ACCESS_CONTROL: "Access Control",
            IP_MAC_BINDING: "IP&MAC Binding",
            IPV6: "IPv6",
            SYSTEM_TOOLS: "System Tools",
            TIME_SETTINGS: "Time Settings",
            DIAGNOSTIC: "Diagnostics",
            FIRMWARE_UPGRADE: "Firmware Upgrade",
            BACKUP_RESTORE: "Backup & Restore",
            ADMINISTRATION: "Administration",
            SYSTEM_LOG: "System Log",
            STATISTICS: "Traffic Statistics",
            SYSTEM_PARAMETERS: "System Parameters",
            VPN: "VPN Server",
            OPEN_VPN: "OpenVPN",
            PPTP_VPN: "PPTP VPN",
            VPN_CONNECTIONS: "VPN Connections"
        },
        BASIC_NETWORK: {
            INTERNET: "Internet",
            INTERNET_STATUS: "Internet Status",
            PLC_NETWORK: "Powerline Network",
            POWERLINE: "Powerline",
            PLC_TITLE: "Powerline",
            PLC_MAC: "MAC Address",
            PLC_PASSWORD: "Powerline Key",
            PLC_NETWORK_NAME: "Network Name",
            PLC_ADD_DEVICE: "Powerline Key",
            GHZ24: "2.4GHz",
            GHZ5: "5GHz",
            WIFI_MOVE: "Wi-Fi Move",
            CONNECTION_TYPE: "Connection Type",
            SECONDARY_CONN: "Secondary Connection",
            CONNECTED: "Connected",
            DISCONNECTED: "Disconnected",
            POOR_CONNECTED: "Poor Connected",
            UNPLUGGED: "The WAN port is unplugged.",
            CONNECTED: "Connected",
            DISCONNECTED: "Disconnected",
            INTERNET_IP_ADDR: "IP Address",
            IP_ADDR: "IP Address",
            MAC_ADDR: "MAC Address",
            GATEWAY: "Gateway",
            AUTO: "Auto",
            ROUTER: "Router",
            WIRELESS_CLIENTS: "Wireless Clients",
            HOST_CLIENTS: "Host Clients",
            GUEST_CLIENTS: "Guest Clients",
            WIRE_CLIENTS: "Wired Clients",
            PRINTER: "Printer",
            USB_DISK: "USB Disk",
            WIRELESS: "Wireless",
            GUEST: "Guest Network",
            NAME: "Name",
            WIRELESS_DENY: "Modify",
            MSGBOX: "Are you sure to add this device to wireless mac filter?",
            SSID: "SSID",
            CHANNEL: "Channel",
            MAC: "MAC",
            PASSWORD: "Password",
            ADD: "Add",
            CANCEL: "Cancel",
            BACK: "Back",
            WIRELESS_24GHZ: "2.4GHz Wireless Network",
            WIRELESS_5GHZ: "5GHz Wireless Network",
            AUTO_CHANNEL: "Auto",
            CURRENT_CHANNEL: "Current channel",
            GUEST_24GHZ: "2.4GHz Guest Network",
            GUEST_5GHZ: "5GHz Guest Network",
            STATUS: "Status",
            TOTAL: "Total",
            AVAILABLE: "Available",
            GB: "GB",
            BRAND: "Brand",
            DYNAMIC_IP: "Dynamic IP",
            STATIC_IP: "Static IP",
            SUBNET_MASK: "Subnet Mask",
            PPPOE: "PPPoE",
            BIGPOND_CABLE: "BigPond Cable",
            L2TP: "L2TP",
            PPTP: "PPTP",
            TUNNEL_6TO4: "6to4 Tunnel",
            NONE: "None"
        },
        BASIC_PLC: {
            TITLE: "Powerline Device List",
            DEVICE_NAME: "Device Name",
            MAC_ADDRESS: "MAC Address",
            PASSWORD: "Password",
            RX_RATE: "RX Rate",
            TX_RATE: "TX Rate",
            STATUS: "Status",
            PLC_NOTE: "Powerline Devices",
            PLC_DESC: "List of all Powerline devices in the current powerline network.",
            ADD_PLC: "Adding powerline device, please wait.",
            ADD_DEV: "Add a New Device",
            ADD_FAIL: "Device not added.",
            INVALID_PWD: "Invalid Powerline Key.",
            NOTE: "Please enter the Powerline Key printed on its back.",
            REFRESH: "Refresh",
            LOCAL_DEV: "Local Device"
        },
        BASIC_INTERNET: {
            TITLE: "Internet",
            AUTO_DETECT: "Auto Detect",
            INTERNET_CONN_TYPE: "Internet Connection Type",
            DYNAMIC_IP: "Dynamic IP",
            STATIC_IP: "Static IP",
            PPPOE: "PPPoE",
            BIGPOND: "BigPond Cable",
            L2TP: "L2TP",
            PPTP: "PPTP",
            DHCP: "Dhcp",
            UNPLUGGED: "Unplugged",
            NONE: "None",
            DETECT_FAIL: "Auto detect failed",
            SECONDARY_CONN: "Secondary Connection",
            DYNAMIC_YES: "Do NOT Clone MAC Address",
            DYNAMIC_NO: "Clone Current Computer MAC Address",
            IP_ADDR: "IP Address",
            SUBNET_MASK: "Subnet Mask",
            DEFAULT_GATEWAY: "Default Gateway",
            PRIMARY_DNS: "Primary DNS",
            SECOND_DNS: "Secondary DNS",
            OPTIONAL: "(Optional)",
            USER_NAME: "Username",
            PASSWORD: "Password",
            SERVER_IP_ADDR_NAME: "VPN Server IP/Domain Name",
            DNS_ADDR_MODE: "",
            NOTE: "If you are not sure which Internet Connection Type you have, use Auto Detect or contact your Internet Service Provider (ISP) for assistance."
        },
        BASIC_WIRELESS: {
            TITLE: "Wireless Settings",
            MODE_2G: "2.4GHz",
            MODE_5G: "5GHz",
            WIRELESS_NETWORK_NAME: "Network Name (SSID)",
            WIRELESS_PASSWORD: "Password",
            ENABLE_WIRELESS: "Enable Wireless Radio",
            SAVE: "Save",
            ENCRYPTION_2G_NOTICE: "2.4GHz encryption is %s.",
            ENCRYPTION_5G_NOTICE: "5GHz encryption is %s.",
            ENCRYPTION_2G_NO: "2.4GHz wireless network isn't encrypted.",
            ENCRYPTION_5G_NO: "5GHz wireless network isn't encrypted.",
            ENCRYPTION_SURE: "Are you sure to continue?",
            HIDE_SSID: "Hide SSID"
        },
        STATUS: {
            TITLE: "Status",
            INTERNET: "Internet",
            WIRELESS: "Wireless",
            LAN: "LAN",
            USB_TITLE: "USB Devices",
            PERFORMANCE: "Performance",
            GUEST_NETWORK: "Guest Network",
            ACCESS_DEVICES: "Access Devices",
            IPV4: "IPv4",
            IPV6: "IPv6",
            HZ24G: "2.4GHz",
            HZ5G: "5GHz",
            CONNECTION_TYPE: "Connection Type",
            MAC_ADDRESS: "MAC Address",
            IP_ADDRESS: "IP Address",
            RELEASE: "Release",
            RENEW: "Renew",
            DYNAMIC_IP: "Dynamic IP",
            STATIC_IP: "Static IP",
            SUBNET_MASK: "Subnet Mask",
            PPPOE: "PPPoE",
            BIGPOND_CABLE: "BigPond Cable",
            L2TP: "L2TP",
            PPTP: "PPTP",
            TUNNEL_6TO4: "6to4 Tunnel",
            RD6: "6RD",
            DSLITE: "DS-Lite",
            PASSTHROUGH: "Pass-Through (Bridge)",
            RDNSS: "RDNSS",
            SLAAC: "SLAAC",
            NONE: "None",
            DEFAULT_GATEWAY: "Default Gateway",
            DNS: "DNS Server",
            MAC: "MAC Address",
            WDS_STATUS: "WDS Status",
            IPV6_ADDRESS: "IP Address",
            PRIMARY_DNS: "Primary DNS",
            SECOND_DNS: "Secondary DNS",
            RADIO: "Wireless Radio",
            NAME_SSID: "Name (SSID)",
            NETWORK_NAME_SSID: "Network Name (SSID)",
            HIDE_SSID: "Hide SSID",
            MODE: "Mode",
            CHANNEL: "Channel",
            CHANNEL_WIDTH: "Channel Width",
            AUTO: "Auto",
            CURRENT_CHANNEL: "Current Channel",
            WDS: "WDS Status",
            WIRED_CLIENTS: "Wired Clients",
            WIRELESS_CLIENTS: "Wireless Clients",
            ENABLE_DHCP: "DHCP",
            LINKADDR: "Link-local Address",
            ASSIGN_TYPE: "Assigned Type",
            ALLOW_TO_SEE_EACH: "Allow guests to see each other",
            TOTAL: "Total:",
            AVAILABLE: "Available:",
            USB: "USB Disk",
            PRINTER: "Printer",
            CPU_LOAD: "CPU Load",
            MEMORY_USAGE: "Memory Usage",
            IP_ADDR_P: "IP Address:",
            MAC_ADDR_P: "MAC Address:",
            CONN_TYPE_P: "Connection Type:",
            DISABLED: "Disabled",
            INIT: "Init",
            SCAN: "Scan",
            AUTH: "Auth",
            ASSOC: "Assoc",
            RUN: "Run",
            HOST: "Host",
            GUEST: "Guest",
            ON: "On",
            OFF: "Off"
        },
        PLC: {
            TITLE: "Powerline",
            PLC: "Powerline",
            MAC_ADDR: "MAC Address",
            PASSWORD: "Powerline Key",
            NTWNAME: "Network Name",
            DEFAULT: "Default",
            PLACEHOLDER: "4 to 23 characters"
        },
        LAN: {
            TITLE: "LAN",
            LAN_TYPE: "LAN Type",
            LAN_SETTING: "LAN Settings",
            ETHERNET: "Ethernet",
            IPV4: "IPv4",
            LAN: "LAN",
            IPV6: "IPv6",
            LAN_DYNAMIC_IP: "Dynamic IP",
            LAN_STATIC_IP: "Static IP",
            DEFAULT_GATEWAY: "Default Gateway",
            LAN_IPv4: "LAN IPv4",
            LAN_IPv6: "LAN IPv6",
            MAC_ADDRESS: "MAC Address",
            IP_ADDRESS: "IP Address",
            SUBNET_MASK: "Subnet Mask",
            CUSTOM: "Custom",
            IGMP: "Enable IGMP Proxy",
            ASSIGNED_TYPE: "Assigned Type",
            DHCP_SERVER: "DHCPv6",
            SLAAC: "SLAAC+Stateless DHCP",
            RDNSS: "SLAAC+RDNSS",
            PREFIX: "Address Prefix",
            PREFIX_UNIT: "/64",
            ADDRESS: "Address",
            DELEFATED: "Delegated",
            STATIC: "Static",
            SITE_PREFIX: "Site Prefix",
            SITE_PREFIX_LEN: "Site Prefix Length",
            PREFIX_TYPE: "Site Prefix configuration Type",
            LAN_IPV6_ADDR: "LAN IPV6 Address",
            RELEASE_TIME: "Release Time",
            RELEASE_TIME_TIP: "seconds. (The default is 86400, do not change unless necessary.)",
            ADDRESS: "Address",
            SAVE: "Save",
            REBOOT_TIP: "The extender is skipping to the new login page. <br/> Please wait..."
        },
        LED_SETTINGS: {
            LED_SETTINGS: "LED Schedules",
            LED_SETTINGS_SWITCH: "LED Scheduler",
            LED_SCHEDULE_GRID: "LED Off Schedules",
            LED_ON: "LED On",
            LED_OFF: "LED Off",
            LED_OFF_TIP: "Time for LED off",
            WEEK: "Week",
            ENABLE_THIS_ENTRY: "Enable this entry",
            PROMPT: "LED Off Time"
        },
        WIFI_CLONE: {
            WIFI_CLONE: "Wi-Fi Band Selection",
            NOTE: "Select one or both to be cloned.",
            BAND2: "2.4GHz",
            BAND5: "5GHz",
            DUAL_BAND: "2.4GHz & 5GHz"
        },
        WIFI_MOVE: {
            WIFI_MOVE: "Wi-Fi Move",
            CONFIRM: "",
            TIP: "All activated Wi-Fi Move enabled devices automatically synchronise all Wi-Fi settings with each other.In order to use Wi-Fi Move Technology, you will need at least two TP_LINK extender in your powerline network.",
            CHECK_BOX: "Enable Wi-Fi Move",
            CONFIRM: "Continue",
            NOTE: "Wi-Fi Move function synchronizes all Wi-Fi Settings and LED Schedules."
        },
        WIRELESS: {
            GLOBAL_SETTINGS: "Settings",
            NOT_SUPPORT_5G: "The country only support 2G. Please ensure you select a correct country.",
            REGION: "Region",
            NOTICE: "To use wireless function, you should keep wireless hardware switch on.",
            SAVE: "Save",
            MODE_2G: "2.4GHz",
            MODE_5G: "5GHz",
            WIRELESS: "Wireless",
            WIRELESS_RADIO_2G: "2.4GHz",
            WIRELESS_RADIO_5G: "5GHz",
            ENABLE_WIRELESS: "Enable Wireless Radio",
            WIRELESS_NETWORK_NAME: "Network Name (SSID)",
            WIRELESS_PASSWORD: "Password",
            HIDE_SSID: "Hide SSID",
            SECURITY: "Security",
            NO_SECURITY: "No Security",
            WPA_WPA2_PERSONAL: "WPA/WPA2-Personal (Recommended)",
            WPA_WPA2_ENTERPRISE: "WPA/WPA2-Enterprise",
            WEP: "WEP",
            VERSION: "Version",
            AUTO: "Auto",
            WPA_PSK: "WPA-PSK",
            WPA2_PSK: "WPA2-PSK",
            WPA: "WPA",
            WPA2: "WPA2",
            ENCRYPTION: "Encryption",
            TKIP: "TKIP",
            AES: "AES",
            MODE: "Mode",
            MODE_B: "802.11b only",
            MODE_G: "802.11g only",
            MODE_N: "802.11n only",
            MODE_BG: "802.11b/g mixed",
            MODE_NG: "802.11b/g/n mixed",
            MODE_GN: "802.11g/n mixed",
            MODE_A: "802.11ac only",
            MODE_NA: "802.11n/ac mixed",
            MODE_AN: "802.11n only",
            MODE_AC: "802.11a/n/ac mixed",
            CHANNEL_WIDTH: "Channel Width",
            CHANNEL: "Channel",
            TRANSMIT_POWER: "Transmit Power",
            RADIUS_SERVER_IP: "RADIUS Server IP",
            RADIUS_PORT: "RADIUS Port",
            RADIUS_PASSWORD: "Password",
            TYPE: "Type",
            OPEN_SYSTEM: "Open System",
            SHARED_KEY: "Shared Key",
            KEY_SELECTED: "Key Selected",
            KEY1: "Key1",
            KEY2: "Key2",
            KEY3: "Key3",
            KEY4: "Key4",
            WEP_KEY_FORMAT: "WEP Key Format",
            ASCII: "ASCII",
            HEXADECIMAL: "Hexadecimal",
            KEY_TYPE: "Key Type",
            BIT64: "64 Bit",
            BIT128: "128 Bit",
            BIT152: "152 Bit",
            KEY_VALUE: "Password",
            MHZ: "MHz",
            MHZ20: "20 MHz",
            MHZ40: "40 MHz",
            MHZ80: "80 MHz",
            LOW: "Low",
            MIDDLE: "Middle",
            HIGH: "High",
            CONFIRM: "Changes made to the Wi-Fi Settings and LED Schedules will be synchonized across powerline extenders whose Wi-Fi Move function is enabled. Are you sure you want to continue?",
            CHECK_BOX: "Don't ask me again",
            SCHEDULE_NOTE: "Please make sure the time settings are correct before using this function.",
            SCHEDULE_NOTE_LED: "Any changes made to LED Schedules will be synchronized across powerline extenders whose Wi-Fi Move function is enabled. Be careful to make changes.",
            SCHEDULE_NOTE_WIFI: "Any changes made to Wi-Fi Schedules will be synchronized across powerline extenders whose Wi-Fi Move function is enabled. Be careful to make changes."
        },
        WLAN_TIME_CONTROL: {
            WLAN_TIME_CONTROL: "Wi-Fi Schedules",
            WLAN_TIME_SCHEDULER: "Wi-Fi Scheduler",
            NOTE: "You can make up the schedule which your Wi-Fi is to be disabled for week day.",
            ENABLE: "Enable W-iFi Time Control",
            TYPE: "Do not turn off Wi-Fi while clients are connected to it.",
            WIFI_TIME: "Wi-Fi Off Time",
            STIME: "From",
            ETIME: "To",
            DAYS: "Day(s)",
            SELECT_DAY: "Repeat Every",
            ENABLE_THIS_ENTRY: "Enable this entry",
            TIME_PANEL: "Wi-Fi Off Schedules",
            TIP: "Wi-Fi off schedule",
            PROMPT: "Wi-Fi Off Time"
        },
        MAC_FITLERING: {
            SET: "MAC Filter Settings",
            STATUS: "MAC Filter",
            RULE: "MAC Filter",
            SELECT: "Select the filtering rule",
            BLACK_VAL: "Block wireless access from the devices in the list below.",
            WHITE_VAL: "Allow wireless access only from the devices in the list below.",
            WHITE_LIST: "Device List",
            BLACK_LIST: "Device List",
            MAC_ADDRESS: "MAC Address",
            DESCRIPTION: "Description",
            ENABLE_EDIT: "Enable this entry",
            BTN_VIEW: "View Devices",
            DEVICE_NAME: "Device Name",
            IP_ADDRESS: "IP Address",
            OPERATION: "Operation",
            CHOOSE: "Choose",
            ACCESS_DEVICE: "Access Devices List"
        },
        STATISTICS_WIRELESS: {
            TITLE: "Online Wireless Clients",
            CLIENT_NUMBER: "Total Clients",
            MAC_ADDRESS: "MAC Address",
            CONN_TYPE: "Connection Type",
            SECURITY: "Security",
            RECEIVED_PACKETS: "Received Packets",
            SEND_PACKETS: "Sent Packets",
            WIRELESS_BAND: "Wireless Band"
        },
        GUEST_SETTINGS: {
            GLOBAL_SETTINGS: "Guest Network",
            NOTE: "You can define whether the Guest Network to be shut off after a certain period of time. However, at most, Guest Network is active only for as long as the general Wi-Fi is.",
            MODE_2G: "2.4GHz",
            MODE_5G: "5GHz",
            AUTO_SHUTOFF_ITEM: "Automatic shutoff",
            AUTO_SHUTOFF: "Automatic disable after",
            SEE_EACH: "Enable Guest Network",
            ALLOW_EACH_ITEM: "See each other",
            ALLOW_EACH: "Allow guests to see each other",
            ACCESS_LOCAL_NETWORK: "Access my local network",
            ALLOW_LOCAL_ITEM: "Restricted use",
            ALLOW_LOCAL: "Do not allow guests to manage my network",
            ALLOW_LOCAL_NOTE: "Enable useage resticion if you do not want the wireless devices use the Guest Network to access the Web-based management page.",
            WIRELESS: "Guest Network Settings",
            WIRELESS_RADIO_2G: "2.4GHz",
            WIRELESS_RADIO_5G: "5GHz",
            ENABLE_GUEST: "Enable Guest Network",
            NAME_SSID: "Network Name (SSID)",
            HIDE_SSID: "Hide SSID",
            PASSWORD_CHANGE_CYCLE: "Password Update Interval",
            PER_DAY: "Daily",
            PER_WEEK: "Weekly",
            PER_MONTH: "Monthly",
            NEVER: "Never",
            SECURITY: "Security",
            NO_SECURITY: "No Security",
            WPA_WPA2_PERSONAL: "WPA/WPA2-Personal",
            VERSION: "Version",
            AUTO: "Auto",
            WPA_PSK: "WPA-PSK",
            WPA2_PSK: "WPA2-PSK",
            ENCRYPTION: "Encryption",
            TKIP: "TKIP",
            AES: "AES",
            WIRELESS_PASSWORD: "Password",
            MIN30: "30 minutes",
            HOUR1: " 1 hour",
            HOUR2: " 2 hours",
            HOUR3: " 3 hours",
            HOUR4: " 4 hours",
            HOUR5: " 5 hours",
            HOUR6: " 6 hours",
            HOUR12: "12 hours",
            HOUR18: "18 hours",
            HOUR24: "24 hours",
            HOUR36: "36 hours",
            HOUR48: "48 hours"
        },
        PARENTAL_CTR: {
            TITLE: "Parental Controls",
            STATUS: "Parental Controls",
            UNKNOWN: "Unknown",
            DEVICE_CTR: "Devices Under Parental Controls",
            DEVICE: "Device Name",
            MAC_ADDRESS: "MAC Address",
            TIME: "Internet Access Time",
            DESCRIPTION: "Description",
            ENABLE_THIS_ENTRY: "Enable this Entry",
            OPTIONAL: "(Optional)",
            BTN_VIEW: "View Existing Devices",
            DEVICE_LIST: "Device List",
            SYSTEM_TIME: "System Time",
            RESTR: "Content Restriction",
            MODE: "Restriction",
            BLACKMODE: "Blacklist",
            WHITEMODE: "Whitelist",
            ACCESS_DEVICES_LIST: "Wireless Access Device List",
            CHOOSE: "Choose",
            ADD_A_NEW_KEYWORD: "Add a New Keyword",
            ADD_A_NEW_DOMAIN_NAME: "Add a New Domain Name"
        },
        ACCESS_CTR: {
            ACCESSCTR: "Access Control",
            ENABLE_ACCESS: "Access Control",
            ACCESS_MODE: "Access Mode",
            DEFAULT_ACCESS_MODE: "Default Access Mode",
            BLACK_LIST: "Blacklist",
            WHITE_LIST: "Whitelist",
            WIRED: "Wired",
            WIRELESS: "Wireless",
            DEVICE_ONLINE: "Devices Online",
            NAME: "Device Name",
            IP_ADDRESS: "IP Address",
            MAC_ADDRESS: "MAC Address",
            CONN_TYPE: "Connection Type",
            BLOCK: "Block",
            DEVICE_IN_WHITE: "Devices in Whitelist",
            DEVICE_IN_BLACK: "Devices in Blacklist"
        },
        TIMESET: {
            TITLE: "Time Settings",
            ZONE: "Time Zone",
            DATE: "Date",
            DATEFORMAT_MDY: "MM/DD/YYYY",
            DATEFORMAT_DMY: "DD/MM/YYYY",
            DATEFORMAT_YMD: "YYYY/MM/DD",
            TIME: "Time",
            TIMEFORMAT: "(HH/MM/SS)",
            NTP1: "NTP Server I",
            NTP2: "NTP Server II",
            OPTIONAL: "(Optional)",
            CURRENT_TIME: "Current Time",
            SET_TIME: "Set The Time",
            AUTOMATIC: "Get automatically from the Internet",
            MANUAL: "Manually",
            AUTOMATIC_BTN: "Obtain",
            GETGMT: "Get GMT",
            GETGMT_SUCCESS: "Get Time From NTP Server Success",
            GETGMT_TIMEOUT: "Failed to get time from the NTP server.",
            GETGMT_WAIT: "Waiting",
            M: "M",
            W: "W",
            D: "D",
            H: "H",
            DAYLIGHT_SAVING: "Daylight-Saving Time",
            ENABLE_DAYLIGHT: "Enable Daylight Saving",
            START: "Start",
            END: "End",
            RUNNING_STATUS: "Running Status",
            DOWN: "Daylight saving is down",
            UP: "Daylight saving is up"
        },
        DIAG: {
            TITLE: "Diagnostics",
            DIAGNOSTIC_TOOL: "Diagnostic Tool",
            PING: "Ping",
            TRACE: "Traceroute",
            IPADDR: "IP Address/ Domain Name",
            COUNT: "Ping Count",
            BASIC: "Basic",
            ADVANCED: "Advanced",
            COUNTUNIT: "(1-50)",
            PKT: "Ping Packet Size",
            PKTUNIT: "(4-1472 Bytes)",
            TIMEOUT: "Ping Timeout",
            TIMOUTUNIT: "(100-2000 Milliseconds)",
            TTL: "Traceroute Max TTL",
            TTLUNIT: "(1-30)",
            START: "Start",
            STOP: "Stop"
        },
        FIRMWARE: {
            TITLE: "Firmware Upgrade",
            NEWFILE: "New Firmware File",
            FIRMWAREVERSION: "Firmware Version",
            HARDWAREVERSION: "Hardware Version",
            CONFIRM_CONTENT: "Are you sure you want to update the firmware?",
            WARNING: "Firmware Updating... <br/>Please don't operate during the process.",
            REBOOTING: "Rebooting... <br/>Please don't operate during the rebooting process.",
            UPGRADE: "Upgrade",
            CHECK: "Check",
            LATESTVERSION: "Latest Version",
            CHECK_UPGRADE: "Check for Upgrade",

            FIRMWARE_INFO: "Your firmware is up to date.",
            TITLE: "Manual Upgrade",
            INFO: "Device Information",
            REMOTE_TITLE: "Online Upgrade",
            LOCAL_TITLE: "Local Upgrade",
            DO_NOT_OPERATE: "Upgrading... <br/> To avoid any damage, please keep the extender powered on and do NOT operate the extender during the firmware upgrade process.",
            FIRMWARE_UPDATING_NOTE: "2.Firmware Updating...<br/> To avoid any damage, please keep the extender powered on and do NOT operate the extender during the firmware upgrade process.",
            REBOOTING_NOTE: "3.Rebooting...<br/> To avoid any damage, please keep the extender powered on and do NOT operate the extender during the firmware upgrade process.",
            SCREEN_UPDATING_NOTE: "4.Screen Updating...<br/> To avoid any damage, please keep the extender powered on and do NOT operate the extender duringthe firmware upgrade process.",
            UPGRADE_FAILED: "Upgrade failed.",
            CHECK: "Check",
            DOWNLOADING: "Downloading...<br/> To avoid any damage, please keep the extender powered on and do NOT operate the extender during the firmware upgrade process.",
            UPGRADE_INOF: "To avoid any damage, please keep the extender powered on.",
            NOTE: "Note: ",
            NO_UPGRADE: "This is the latest version.",

            UPGRADING: "Upgrading...<br/> To avoid any damage, please keep the extender powered on and do NOT operate the extender during the firmware upgrade process.",
            RETRY: "Retry",
            CANCEL: "Cancel",
            ILEGAL_DEVICE: "Unable to identify the device. Please contact TP-Link technical support.",
            UPGRADE_FAIL: "Unable to upgrade. Please try again later."
        },
        BACKUP: {
            BACKUP: "Backup",
            BACKUPTIP: "Save a copy of your current settings.",
            RESTORE: "Restore",
            RESTORETIP: "Restore saved settings from a file.",
            RESTORE_WARN: "Restoring... <br/>Please don't operate during the process.",
            RESTORE_CONFIRM_CONTENT: "Are you sure to restore the extender from the backup file?",
            FILE: "File",
            FACTORY: "Factory Default Restore",
            FACTORYTIP: "Revert all the configuration settings to their default values.",
            FACTORY_CONFIRM_CONTENT: "Are you sure to restore the extender to its factory defaults?",
            FACTORY_WARN: "Restoring... <br/>Please don't operate during the process.",
            BACKUPBTN: "Backup",
            RESTOREBTN: "Restore",
            FACTORYBTN: "Factory Restore",
            RESTOREFAIL: "Restore failed" // newfour
        },
        ACCOUNT: {
            ACCOUNT_TITLE: "Account Management",
            OLDUSER: "Old Username",
            OLDPWD: "Old Password",
            NEWUSER: "New Username",
            NEWPWD: "New Password",
            CONFIRM: "Confirm New Password",
            RECOVERYINFO: "Password Recovery",
            ENABLE_PASSWORD_RECOVERY: "Enable Password Recovery",
            FROM: "From",
            TO: "To",
            SMTP_SERVER: "SMTP Server",
            ENABLE_AUTHENTICATION: "Enable Authentication",
            USERNAME: "Username",
            PASSWORD: "Password",
            TEST_MAIL: "Test Mail",
            LOCAL: "Local Management",
            LOCAL_MAC_AUTH: "Local MAC Authentication",
            ACCESS: "Access for All LAN Connected Devices",
            ACCESS_TIPS: "Toggle On to enable the management for all devices on LAN or keep it Off to enable the management for a specific device.",
            MAC_ADDRESS: "MAC Address",
            VIEW_BTN: "View Existing Devices",
            DESCRIPTION: "Description",
            EXIST_DEVICE: "Existing Devices",
            OPTIONAL: "(Optional)",
            ENABLE_THIS_ENTRY: "Enable",
            DEVICE_NAME: "Device Name",
            IP_ADDRESS: "IP Address",
            REMOTE: "Remote Management",
            DISABLE_REMOTE_MANAGEMENR: "Disable Remote Management",
            ENABLE_REMOTE_MANAGEMENR_ALL: "Enable Remote Management for All Devices",
            ENABLE_REMOTE_MANAGEMENR: "Enable Remote Management for Specified Devices",
            WEB: "Web Management Port",
            NOTICE: "In conflict with the virtual server port! Are you sure to continue?",
            REMOTEIP: "Remote Management IP Address",
            REMOTEIPNOTE: "(Enter 255.255.255.255 for all)"
        },
        SYSLOG: {
            TITLE: "System Log",
            LOG_FILTER: "Log Filter:",
            ID: "ID",
            TYPE_EQ: "Type=",

            ALL: "ALL",
            LED_SWITCH: "LED Schedules",
            WIFI_SWITCH: "Wi-Fi Schedules",
            WIFI_MOVE: "Wi-Fi Move",
            LED_SCHEDULES: "LED Schedules",
            WIFI_CLONE: "Wi-Fi Clone",
            WIFI_SCHEDULES: "Wi-Fi Schedules",
            MAC_FILTER: "MAC Filter", // MACFILTERING
            PARENTAL_CONTROLS: "Parental controls", // PARENTAL_CONTROL
            DHCPC: "DHCP Client", // HOST_CLIENTS
            DHCPS: "DHCP Server", // DHCP_SERVER
            OTHERS: "Other",

            DHCP: "DHCP",
            OTHER: "Other",
            LEVEL: "and Level =",
            EMERGENCY: "EMERGENCY",
            ALERT: "ALERT",
            CRITICAL: "CRITICAL",
            ERROR: "ERROR",
            WARNING: "WARNING",
            NOTICE: "NOTICE",
            INFO: "INFO",
            DEBUG: "DEBUG",
            INDEX: "Index",
            TYPE: "Type",
            TIME: "Time",
            LEVEL_COL: "Level",
            CONTENT: "Log Content",
            MAIL_LOG: "Mail Log",
            SAVE_LOG: "Save Log",
            SEND_OK: "Send OK",
            SEND_FAILED: "Send Failed",
            MAIL_SETTING: "Mail Settings",
            FROM: "From",
            TO: "To",
            SMTP_SERVER: "SMTP Server",
            ENABLE_AUTHENTICATION: "Enable Authentication",
            USERNAME: "Username",
            PASSWORD: "Password",
            CONFIRM_PASSWORD: "Confirm Password",
            AUTO_MAIL: "Enable Auto Mail",
            LOG_AT: "Log at",
            HH_MM: "(HH:MM) everyday",
            LOG_EVERY: "Log every",
            HOURS: "hours"
        }

    };
})(jQuery);
